<?php
/**
 * Plugin Name: GBX Blog Suite
 * Description: A comprehensive blog management suite combining API-based post publishing and smart internal linking for enhanced SEO and content automation.
 * Version: 1.0
 * Author: Daniyal Hassan
 * License: GPLv2 or later
 * Requires at least: 5.8
 * Tested up to: 6.5
 * Requires PHP: 7.4
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('GBX_BLOG_SUITE_VERSION', '1.0');
define('GBX_BLOG_SUITE_PATH', plugin_dir_path(__FILE__));
define('GBX_BLOG_SUITE_URL', plugin_dir_url(__FILE__));

// Include required files
require_once GBX_BLOG_SUITE_PATH . 'includes/class-api-publisher.php';
require_once GBX_BLOG_SUITE_PATH . 'includes/class-internal-links.php';
require_once GBX_BLOG_SUITE_PATH . 'includes/class-blog-settings.php';
require_once GBX_BLOG_SUITE_PATH . 'includes/class-admin.php';

/**
 * Main GBX Blog Suite Class
 */
class GBX_Blog_Suite {
    
    private static $instance = null;
    public $api_publisher;
    public $internal_links;
    public $blog_settings;
    public $admin;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        $this->init();
    }
    
    private function init() {
        // Initialize modules
        $this->api_publisher = new GBX_API_Publisher();
        $this->internal_links = new GBX_Internal_Links();
        $this->blog_settings = new GBX_Blog_Settings();
        $this->admin = new GBX_Admin();
        
        // Activation/Deactivation hooks
        register_activation_hook(__FILE__, array($this, 'activate'));
        register_deactivation_hook(__FILE__, array($this, 'deactivate'));
    }
    
    public function activate() {
        // Activation tasks
    }
    
    public function deactivate() {
        // Clear scheduled events
        wp_clear_scheduled_hook('rpp_daily_event');
        delete_option('rpp_daily_enabled');
    }
}

// Initialize the plugin
function gbx_blog_suite() {
    return GBX_Blog_Suite::get_instance();
}

gbx_blog_suite();
